/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.widgets;

import com.quantumdata.widgets.QDStdUI;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.border.Border;

public class QDToggleButton
extends JToggleButton {
    private static final long serialVersionUID = 1L;
    private Border m_normalBorder;
    private Border m_pressedBorder;
    private boolean m_pressing = false;
    private boolean m_mouseOver = false;
    private boolean m_isTight = true;

    public QDToggleButton() {
        this.initLook();
    }

    public QDToggleButton(String string) {
        super(string);
        this.initLook();
    }

    public QDToggleButton(String string, Icon icon) {
        super(string, icon);
        this.initLook();
    }

    public QDToggleButton(Action action) {
        super(action);
        this.initLook();
    }

    public void setTightBorder(boolean bl) {
        if (bl == this.m_isTight) {
            return;
        }
        this.m_isTight = bl;
        if (this.m_isTight) {
            this.m_normalBorder = QDStdUI.getRaisedBorder();
            this.m_pressedBorder = QDStdUI.getLoweredBorder();
        } else {
            Border border = QDStdUI.g_useLargeMenus ? BorderFactory.createEmptyBorder(3, 5, 3, 5) : BorderFactory.createEmptyBorder(2, 2, 2, 2);
            Border border2 = QDStdUI.getRaisedBorder();
            this.m_normalBorder = BorderFactory.createCompoundBorder(border2, border);
            border2 = QDStdUI.getLoweredBorder();
            this.m_pressedBorder = BorderFactory.createCompoundBorder(border2, border);
        }
    }

    private void initLook() {
        this.setFont(QDStdUI.getActionFont());
        this.setForeground(QDStdUI.getActionForeground());
        this.setBackground(QDStdUI.getActionBackground());
        this.setMargin(QDStdUI.getActionInsets());
        this.setBorderPainted(true);
        this.setFocusable(true);
        this.setFocusPainted(false);
        this.setContentAreaFilled(false);
        this.setTightBorder(false);
        this.setBorder(this.m_normalBorder);
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                QDToggleButton.this.m_pressing = true;
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                QDToggleButton.this.m_pressing = false;
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                QDToggleButton.this.m_mouseOver = true;
                QDToggleButton.this.repaint();
            }

            public void mouseExited(MouseEvent mouseEvent) {
                QDToggleButton.this.m_mouseOver = false;
                QDToggleButton.this.repaint();
            }
        });
    }

    public void paint(Graphics graphics) {
        GradientPaint gradientPaint;
        if (this.m_pressing) {
            if (this.m_mouseOver) {
                this.setBorder(this.m_pressedBorder);
            } else {
                this.setBorder(this.m_normalBorder);
            }
            graphics.setColor(Color.lightGray);
            this.setForeground(Color.BLACK);
            gradientPaint = new GradientPaint(0.0f, 0.0f, QDStdUI.getActionBackground(), 0.0f, this.getHeight(), QDStdUI.getBackground());
        } else if (this.isSelected()) {
            this.setBorder(this.m_pressedBorder);
            graphics.setColor(QDStdUI.getBackground());
            if (this.m_mouseOver) {
                this.setForeground(QDStdUI.getFocusColor());
            } else {
                this.setForeground(QDStdUI.getActionForeground());
            }
            gradientPaint = new GradientPaint(0.0f, 0.0f, QDStdUI.getActionBackground(), 0.0f, this.getHeight(), QDStdUI.getBackground());
        } else {
            this.setBorder(this.m_normalBorder);
            if (this.m_mouseOver) {
                this.setForeground(QDStdUI.getFocusColor());
            } else {
                this.setForeground(QDStdUI.getForeground());
            }
            graphics.setColor(QDStdUI.getActionBackground());
            gradientPaint = new GradientPaint(0.0f, 0.0f, QDStdUI.getBackground(), 0.0f, this.getHeight(), QDStdUI.getActionBackground());
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.setPaint(paint);
        if (this.isFocusable() && this.isFocusOwner() && !this.m_pressing) {
            graphics.setColor(QDStdUI.getFocusColor());
            graphics.drawRect(4, 4, this.getWidth() - 8, this.getHeight() - 8);
        }
        if (!this.isBorderPainted()) {
            this.setBorder(null);
        }
        super.paint(graphics);
    }
}

